char_galaga_gptr = 1;
local args = ...
local g = args[1]

-- constants for the enemy states
local STATE_MOVING_LEFT = 1
local STATE_MOVING_RIGHT = 2
local STATE_FIRING = 3

-- constants for the enemy properties
local ENEMY_SIZE = 0.4
local ENEMY_SPACING_X = SCREEN_WIDTH/10
local ENEMY_SPACING_Y = SCREEN_HEIGHT/6
local ENEMY_START_X = SCREEN_WIDTH / 8 + ENEMY_SPACING_X / 2
local ENEMY_START_Y = SCREEN_HEIGHT  / 9 + ENEMY_SPACING_Y / 2

-- create a function to initialize a new enemy
function createEnemy(x, y)
    local ran = math.random(1,2)
    local enemy = {
      pos = {
          x = x,
          y = y
      },
      movingState = ran,
      state = ran,
      timer = math.random(4,20),
      actor = nil,
      alive = true,
      dead = false,
    }
    table.insert(g.Enemies, enemy)
end

local enemies = Def.ActorFrame{

}

-- create a function to initialize the enemies
for i = 1, 3 do
    for j = 1, 8 do
    createEnemy(ENEMY_START_X + (j - 1) * ENEMY_SPACING_X, ENEMY_START_Y + (i - 1) * ENEMY_SPACING_Y)
    end
end
for i=1,25 do
    enemies[#enemies+1] = Def.ActorFrame{

        Def.ActorFrame{
            OnCommand=cmd(visible,true;sleep,0.02;queuecommand,"SetMe"),
            CheckCommand=function(self)
                if g.Enemies[i] == nil then
                    return
                end
                self:linear(0.5):x(g.Enemies[i].pos.x):y(g.Enemies[i].pos.y)
            end,
            SetMeCommand=function(self)
                if g.Enemies[i] == nil then
                    self:visible(false)
                    return
                else 
                    g.Enemies[i].actor = self
                end
                self:zoom(ENEMY_SIZE)
            end,
            DoneCommand=cmd(visible,true),
            Def.ActorFrame {
                HitCommand=function(self)
                    self:linear(0.8):rotationz(-720):zoom(0):diffusealpha(0)
                    self:y(SCREEN_CENTER_Y)
                   -- SM("Enemy Hit ")
                end,
                LoadActor( "sans/SaiyanTate 2x1.png" )..{
                    InitCommand=function (self)
                        self:SetTextureFiltering(false);
                    end,
                    OnCommand=cmd(animate,0;setstate,0),
                    FireCommand=cmd(setstate,1;zoom,1.3;decelerate,0.2;addy,-10;zoom,1;),
                    ResetCommand=cmd(y,0;setstate,0)
                },
                LoadActor( "sans/Hair 4x1.png" )..{
                    InitCommand=function (self)
                        self:SetTextureFiltering(false):zoom(0.9*ENEMY_SIZE):addy(-60);
                    end,
                    OnCommand=cmd(animate,1;setstate,0),
                    FireCommand=cmd(setstate,1;zoom,1.2*ENEMY_SIZE;decelerate,0.2;addy,-10;zoom,0.9*ENEMY_SIZE;),
                    ResetCommand=cmd(y,-60;)
                },
            },

            Def.Quad{
                InitCommand=function (self)
                    self:SetTextureFiltering(false);
                    self:diffuse(color("#398dff")):addx(-15)
                end,
                OnCommand=cmd(vertalign,top;y,-14;zoomx,0;zoomy,10000;diffusealpha,1;),
                FireCommand=cmd(diffusealpha,1;zoomx,0;spring,0.4;zoomx,35;linear,0.3;zoomx,18;accelerate,0.3;zoomx,0;diffusealpha,-0.2)
            },
            Def.Quad{
                InitCommand=function (self)
                    self:SetTextureFiltering(false);
                    self:diffuse(color("#4e99ff")):addx(-15)
                end,
                OnCommand=cmd(vertalign,top;y,-14;zoomx,0;zoomy,10000;diffusealpha,1;),
                FireCommand=cmd(diffusealpha,1;zoomx,0;spring,0.4;zoomx,20;linear,0.2;zoomx,18;accelerate,0.2;zoomx,0;diffusealpha,-0.2)
            },
            Def.Quad{
                InitCommand=function (self)
                    self:SetTextureFiltering(false);
                    self:diffuse(color("#398dff")):addx(20)
                end,
                OnCommand=cmd(vertalign,top;y,-14;zoomx,0;zoomy,10000;diffusealpha,1;),
                FireCommand=cmd(diffusealpha,1;zoomx,0;spring,0.4;zoomx,35;linear,0.3;zoomx,18;accelerate,0.3;zoomx,0;diffusealpha,-0.2)
            },
            Def.Quad{
                InitCommand=function (self)
                    self:SetTextureFiltering(false);
                    self:diffuse(color("#4e99ff")):addx(20)
                end,
                OnCommand=cmd(vertalign,top;y,-14;zoomx,0;zoomy,10000;diffusealpha,1;),
                FireCommand=cmd(diffusealpha,1;zoomx,0;spring,0.4;zoomx,20;linear,0.2;zoomx,18;accelerate,0.2;zoomx,0;diffusealpha,-0.2)
            },
        }
    }
end

  
function GetNewEnemy()
	local a = g.Enemies[char_galaga_gptr].actor
	
	char_galaga_gptr = char_galaga_gptr+1
	if char_galaga_gptr > #g.Enemies then
		char_galaga_gptr = 1;
	end
	
	if a then
		a:visible(true);
		a:playcommand('Reset');
		return a
	else
		char_galaga_missing:visible(true)
		return char_galaga_missing
	end
end

function GetEnemy(n)
	local a = g.Enemies[n].actor
	
	if a then
		a:visible(true);
		a:playcommand('Reset');
		return a
	else
		char_galaga_missing:visible(true)
		return char_galaga_missing
	end
end

local characters = Def.ActorFrame{

	InitCommand=function(self)
		af = self
		TimeAtInit = GetTimeSinceStart()
		self:queuecommand("SetUpdate")
			:sleep(9999)
	end,
	SetUpdateCommand=function(self)
		
	end,

	
	Def.Quad{
		OnCommand=cmd(visible,false),
		InitCommand=function(self)
		
			char_galaga_gaster_snd = self
		end,
		SpawnCommand=function(self) enemiesound('gaster_spawn') end,
		FireCommand=function(self) enemiesound('gaster_fire') end,
	},
	
	Def.Quad{
		InitCommand=function(self) char_galaga_missing = self end,
		OnCommand=cmd(visible,false;diffuse,1,0,1,1;zoomto,64,64),
		DoneCommand=cmd(visible,false),
	}
	
}


characters[#characters+1] = enemies;

return characters